

import { ActivityPopup } from './ActivityPopup.js';


export class ActivityListWidget {

	ezTpl = null;
	
	pageNo = 0;
	
	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<a href="{{appUrl('/masterdata/')}}" class="fa fa-chevron-circle-left"></a>
			</div>
			<h1>Logboek</h1>
		</div>
		
		<div ez-subtemplate="activityresults">
			<div ez-if="typeof acts == 'undefined' || acts == null">
				Loading...
			</div>
			<div ez-if="typeof acts != 'undefined' && acts != null">
				<table class="table tbl-activities">
					<thead>
						<tr>
							<th style="width: 80px;">#</th>
							<th style="width: 250px;"><input type="text" name="refObject" placeholder="Ref. Object" /></th>
							<th style="width: 100px;"><input type="text" name="refId" placeholder="Ref. Id" /></th>
							<th><input type="text" name="shortDescription" placeholder="Omschrijving" /></th>
							<th style="width: 125px;"><input type="text" name="username" placeholder="{{_('Username')}}" /></th>
							<th style="width: 160px;">Tijdstip</th>
						</tr>
					</thead>
					<tbody ez-for="acts" ez-item="a">
						<tr [onclick]="widget.viewActivity" class="pointer" data-activity-id="{{a.activityId}}">
							<td>{{ a.activityId }}</td>
							<td>{{ a.refObject != null ? a.refObject : '' }}</td>
							<td>{{ a.refId != null ? a.refId : '' }}</td>
							<td>{{a.shortDescription}}</td>
							<td>{{a.username != null ? a.username : ''}}</td>
							<td>{{format_datetime(a.created)}}</td>
						</tr>
					</tbody>
						<tr ez-if="acts.length == 0">
							<td colspan="100%" class="no-results">Geen resultaten gevonden</td>
						</tr>
				</table>
				
				<ez-pager></ez-pager>
			</div>
		</div>
	`;
	
	
	loadActivity() {
		
		let data = {};
		data.pageNo = this.pageNo;
		
		if ( $('.tbl-activities thead input').length > 0 ) {
			data.refObject = $('input[name=refObject]').val();
			data.refId = $('input[name=refId]').val();
			data.shortDescription = $('input[name=shortDescription]').val();
			data.username = $('input[name=username]').val();
		}
		
		postUrl(
			'/service/activity.do'
			, data).then( async function(e) {
				let json = await e.json();
				
				if (json.error) {
					showErrorWidget( json );
				}
				
	
				let tpl = document.querySelector('[ez-subtemplate="activityresults"]').eztemplate;
				
				let oldThead = document.querySelector( '.tbl-activities thead' );
				let oldActiveElement = document.activeElement;
	
				tpl.setObject('widget', this);
				tpl.setVar('acts', json.acts);
				tpl.setVar('response', json);
				tpl.render();
				
				if (oldThead) {
					$('.tbl-activities thead').remove();
					$('.tbl-activities').prepend( oldThead );
					
					if (oldActiveElement)
						$(oldActiveElement).focus();
				}
				
				$('.tbl-activities thead tr').find('input').on('change', function() {
					this.pageNo = 0;
					this.loadActivity();
				}.bind(this));
			}.bind(this) );
	}
	
	
	init(e) {
		this.pageNo = getUrlParam('pageNo') ?? 0;
		
		this.ezTpl = new EzTemplate( e );
		this.ezTpl.setVar('contracts', null);
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.render();
		
		
		this.loadActivity();
	}
	
	selectPage( pageNo ) {
		this.pageNo = pageNo;
		this.loadActivity();
//		gotoRoute( '/masterdata/activity/?pageNo=' + pageNo );
	}
	
	viewActivity( evt ) {
		let activityId = $(evt.currentTarget).data('activity-id');
		
		let ap = new ActivityPopup( activityId );
		ap.showPopup();
	}
	
}

